-- --------------------------------------------------------------------
--  Oct 2017 Grald St-Georges
-- --------------------------------------------------------------------
--  Added new columns for US3695 Siemens new Quota tracking by period.
-- --------------------------------------------------------------------

-- Added following script to correct trigger that was done in first instance of script 1104 that has been fixed since but may have been runned on some servers.
IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[TRUPDATE_QUOTA]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
  DROP TRIGGER [dbo].[TRUPDATE_QUOTA]
GO
/****** Object:  Trigger [dbo].[TRUPDATE_QUOTA]    Script Date: 4/15/2014 12:20:17 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER [dbo].[TRUPDATE_QUOTA] ON [dbo].[Quota] FOR  Update  AS
 IF Update(QtStatus) and exists (select 1 from inserted inner join deleted on inserted.QtQuotaid=deleted.Qtquotaid where inserted.Qtstatus<>deleted.Qtstatus)
 begin
   DELETE FROM dbo.bufferNew
 end
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------

IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'ValidityPeriod' AND object_id = OBJECT_ID(N'Quota'))
BEGIN
  ALTER TABLE Quota ADD ValidityPeriod int NOT NULL DEFAULT (0),
                        SurveyStartingMonth int NULL,
                        BreakdownTimeInterval int NOT NULL DEFAULT (0),
                        SampleLoadDayOfWeek int NULL,
                        QuotaBuffer int NULL,
                        QuotaForThePeriod int NULL,
                        FrequencyForThePeriod int NOT NULL DEFAULT (0),
                        GlobalPeriodStartDate datetime NULL,
                        BreakdownPeriodStartDate datetime NULL
END
GO
-- Following index are not needed since never used.
IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Quota]') AND name = N'IxQtOnLine')
DROP INDEX [IxQtOnLine] ON [dbo].[Quota]
GO
IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Quota]') AND name = N'IxQtFrequence')
DROP INDEX [IxQtFrequence] ON [dbo].[Quota]
GO
IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Quota]') AND name = N'IxQtGroup')
DROP INDEX [IxQtGroup] ON [dbo].[Quota]
GO
IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Quota]') AND name = N'IxQtQuota')
DROP INDEX [IxQtQuota] ON [dbo].[Quota]
GO
IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Quota]') AND name = N'IxQtSchedule')
DROP INDEX [IxQtSchedule] ON [dbo].[Quota]
GO

UPDATE Quota SET [QtUnused] = 0 WHERE [QtUnused] Is NULL
GO
UPDATE Quota SET [QtOnLine] = 0 WHERE [QtOnLine] Is NULL
GO
UPDATE Quota SET [QtFrequence] = 0 WHERE [QtFrequence] Is NULL
GO

DECLARE @ConstraintToDrop nvarchar(1000)
DECLARE @SqlQuery nvarchar(1100)
SET @ConstraintToDrop = ''
select @ConstraintToDrop = D.Name
      from sys.all_columns c
      join sys.tables t on t.object_id = c.object_id
      join sys.schemas s on s.schema_id = t.schema_id
      join sys.default_constraints d on c.default_object_id = d.object_id
    where t.name = 'Quota'
      and c.name = 'QtUnused'
      and s.name = 'dbo'
if @ConstraintToDrop != ''
BEGIN
  SET @SqlQuery = 'ALTER TABLE [dbo].[Quota] DROP CONSTRAINT ' + @ConstraintToDrop
  EXECUTE sp_executesql @SqlQuery
END
GO
ALTER TABLE [dbo].[Quota] ADD  CONSTRAINT DF_Quota_QtUnused  DEFAULT ((0)) FOR [QtUnused]
GO
DECLARE @ConstraintToDrop nvarchar(1000)
DECLARE @SqlQuery nvarchar(1100)
SET @ConstraintToDrop = ''
select @ConstraintToDrop = D.Name
      from sys.all_columns c
      join sys.tables t on t.object_id = c.object_id
      join sys.schemas s on s.schema_id = t.schema_id
      join sys.default_constraints d on c.default_object_id = d.object_id
    where t.name = 'Quota'
      and c.name = 'QtOnLine'
      and s.name = 'dbo'
if @ConstraintToDrop != ''
BEGIN
  SET @SqlQuery = 'ALTER TABLE [dbo].[Quota] DROP CONSTRAINT ' + @ConstraintToDrop
  EXECUTE sp_executesql @SqlQuery
END
GO
ALTER TABLE [dbo].[Quota] ADD  CONSTRAINT DF_Quota_QtOnLine  DEFAULT ((0)) FOR [QtOnLine]
GO
DECLARE @ConstraintToDrop nvarchar(1000)
DECLARE @SqlQuery nvarchar(1100)
SET @ConstraintToDrop = ''
select @ConstraintToDrop = D.Name
      from sys.all_columns c
      join sys.tables t on t.object_id = c.object_id
      join sys.schemas s on s.schema_id = t.schema_id
      join sys.default_constraints d on c.default_object_id = d.object_id
    where t.name = 'Quota'
      and c.name = 'QtFrequence'
      and s.name = 'dbo'
if @ConstraintToDrop != ''
BEGIN
  SET @SqlQuery = 'ALTER TABLE [dbo].[Quota] DROP CONSTRAINT ' + @ConstraintToDrop
  EXECUTE sp_executesql @SqlQuery
END
GO
ALTER TABLE [dbo].[Quota] ADD  CONSTRAINT DF_Quota_QtFrequence  DEFAULT ((0)) FOR [QtFrequence]
GO

ALTER TABLE [dbo].[Quota] ALTER COLUMN [QtUnused] float NOT NULL 
GO
ALTER TABLE [dbo].[Quota] ALTER COLUMN [QtOnLine] int NOT NULL 
GO
ALTER TABLE [dbo].[Quota] ALTER COLUMN [QtFrequence] float NOT NULL 
GO

--Rename existing constraint with fixed named instead of Microsoft name with Guid.
DECLARE @ConstraintToDrop nvarchar(1000)
DECLARE @SqlQuery nvarchar(1100)
SET @ConstraintToDrop = ''
select @ConstraintToDrop = D.Name
      from sys.all_columns c
      join sys.tables t on t.object_id = c.object_id
      join sys.schemas s on s.schema_id = t.schema_id
      join sys.default_constraints d on c.default_object_id = d.object_id
    where t.name = 'Quota'
      and c.name = 'BreakdownTimeInterval'
      and s.name = 'dbo'
if @ConstraintToDrop != ''
BEGIN
  SET @SqlQuery = 'ALTER TABLE [dbo].[Quota] DROP CONSTRAINT ' + @ConstraintToDrop
  EXECUTE sp_executesql @SqlQuery
END
GO
ALTER TABLE [dbo].[Quota] ADD  CONSTRAINT DF_Quota_BreakdownTimeInterval  DEFAULT ((0)) FOR [BreakdownTimeInterval]
GO
DECLARE @ConstraintToDrop nvarchar(1000)
DECLARE @SqlQuery nvarchar(1100)
SET @ConstraintToDrop = ''
select @ConstraintToDrop = D.Name
      from sys.all_columns c
      join sys.tables t on t.object_id = c.object_id
      join sys.schemas s on s.schema_id = t.schema_id
      join sys.default_constraints d on c.default_object_id = d.object_id
    where t.name = 'Quota'
      and c.name = 'FrequencyForThePeriod'
      and s.name = 'dbo'
if @ConstraintToDrop != ''
BEGIN
  SET @SqlQuery = 'ALTER TABLE [dbo].[Quota] DROP CONSTRAINT ' + @ConstraintToDrop
  EXECUTE sp_executesql @SqlQuery
END
GO
ALTER TABLE [dbo].[Quota] ADD  CONSTRAINT DF_Quota_FrequencyForThePeriod  DEFAULT ((0)) FOR [FrequencyForThePeriod]
GO
DECLARE @ConstraintToDrop nvarchar(1000)
DECLARE @SqlQuery nvarchar(1100)
SET @ConstraintToDrop = ''
select @ConstraintToDrop = D.Name
      from sys.all_columns c
      join sys.tables t on t.object_id = c.object_id
      join sys.schemas s on s.schema_id = t.schema_id
      join sys.default_constraints d on c.default_object_id = d.object_id
    where t.name = 'Quota'
      and c.name = 'ValidityPeriod'
      and s.name = 'dbo'
if @ConstraintToDrop != ''
BEGIN
  SET @SqlQuery = 'ALTER TABLE [dbo].[Quota] DROP CONSTRAINT ' + @ConstraintToDrop
  EXECUTE sp_executesql @SqlQuery
END
GO
ALTER TABLE [dbo].[Quota] ADD  CONSTRAINT DF_Quota_ValidityPeriod  DEFAULT ((0)) FOR [ValidityPeriod]
GO




--Add new column to Respondent table
IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'ResCompletedDate' AND object_id = OBJECT_ID(N'Respondent'))
BEGIN
  ALTER TABLE Respondent ADD ResCompletedDate datetime NULL
END
GO

